/* SPDX-License-Identifier: GPL-2.0-or-later */
/* This file was generated by: ./scripts/crypto/gen-hash-testvecs.py sha256 */

static const struct {
	size_t data_len;
	u8 digest[SHA256_DIGEST_SIZE];
} hash_testvecs[] = {
	{
		.data_len = 0,
		.digest = {
			0xe3, 0xb0, 0xc4, 0x42, 0x98, 0xfc, 0x1c, 0x14,
			0x9a, 0xfb, 0xf4, 0xc8, 0x99, 0x6f, 0xb9, 0x24,
			0x27, 0xae, 0x41, 0xe4, 0x64, 0x9b, 0x93, 0x4c,
			0xa4, 0x95, 0x99, 0x1b, 0x78, 0x52, 0xb8, 0x55,
		},
	},
	{
		.data_len = 1,
		.digest = {
			0x45, 0xf8, 0x3d, 0x17, 0xe1, 0x0b, 0x34, 0xfc,
			0xa0, 0x1e, 0xb8, 0xf4, 0x45, 0x4d, 0xac, 0x34,
			0xa7, 0x77, 0xd9, 0x40, 0x4a, 0x46, 0x4e, 0x73,
			0x2c, 0xf4, 0xab, 0xf2, 0xc0, 0xda, 0x94, 0xc4,
		},
	},
	{
		.data_len = 2,
		.digest = {
			0xf9, 0xd3, 0x52, 0x2f, 0xd5, 0xe0, 0x99, 0x15,
			0x1c, 0xd6, 0xa9, 0x24, 0x4f, 0x40, 0xba, 0x25,
			0x33, 0x43, 0x3e, 0xe1, 0x78, 0x6a, 0xfe, 0x7d,
			0x07, 0xe2, 0x29, 0x7b, 0x6d, 0xc5, 0x73, 0xf5,
		},
	},
	{
		.data_len = 3,
		.digest = {
			0x71, 0xf7, 0xa1, 0xef, 0x69, 0x86, 0x0e, 0xe4,
			0x87, 0x25, 0x58, 0x4c, 0x07, 0x2c, 0xfc, 0x60,
			0xc5, 0xf6, 0xe2, 0x44, 0xaa, 0xfb, 0x41, 0xc7,
			0x2b, 0xc5, 0x01, 0x8c, 0x39, 0x98, 0x30, 0x37,
		},
	},
	{
		.data_len = 16,
		.digest = {
			0x09, 0x95, 0x9a, 0xfa, 0x25, 0x18, 0x86, 0x06,
			0xfe, 0x65, 0xc9, 0x2f, 0x91, 0x15, 0x74, 0x06,
			0x6c, 0xbf, 0xef, 0x7b, 0x0b, 0xc7, 0x2c, 0x05,
			0xdd, 0x17, 0x5d, 0x6f, 0x8a, 0xa5, 0xde, 0x3c,
		},
	},
	{
		.data_len = 32,
		.digest = {
			0xe5, 0x52, 0x3c, 0x85, 0xea, 0x1b, 0xe1, 0x6c,
			0xe0, 0xdb, 0xc3, 0xef, 0xf0, 0xca, 0xc2, 0xe1,
			0xb9, 0x36, 0xa1, 0x28, 0xb6, 0x9e, 0xf5, 0x6e,
			0x70, 0xf7, 0xf9, 0xa7, 0x1c, 0xd3, 0x22, 0xd0,
		},
	},
	{
		.data_len = 48,
		.digest = {
			0x5f, 0x84, 0xd4, 0xd7, 0x2e, 0x80, 0x09, 0xef,
			0x1c, 0x77, 0x7c, 0x25, 0x59, 0x63, 0x88, 0x64,
			0xfd, 0x56, 0xea, 0x23, 0xf4, 0x4f, 0x2e, 0x49,
			0xcd, 0xb4, 0xaa, 0xc7, 0x5c, 0x8b, 0x75, 0x84,
		},
	},
	{
		.data_len = 49,
		.digest = {
			0x22, 0x6e, 0xca, 0xda, 0x00, 0x2d, 0x90, 0x96,
			0x24, 0xf8, 0x55, 0x17, 0x11, 0xda, 0x42, 0x1c,
			0x78, 0x4e, 0xbf, 0xd9, 0xc5, 0xcf, 0xf3, 0xe3,
			0xaf, 0xd3, 0x60, 0xcd, 0xaa, 0xe2, 0xc7, 0x22,
		},
	},
	{
		.data_len = 63,
		.digest = {
			0x97, 0xe2, 0x74, 0xdc, 0x6b, 0xa4, 0xaf, 0x32,
			0x3b, 0x50, 0x6d, 0x80, 0xb5, 0xd3, 0x0c, 0x36,
			0xea, 0x3f, 0x5d, 0x36, 0xa7, 0x49, 0x51, 0xf3,
			0xbd, 0x69, 0x68, 0x60, 0x9b, 0xde, 0x73, 0xf5,
		},
	},
	{
		.data_len = 64,
		.digest = {
			0x13, 0x74, 0xb1, 0x72, 0xd6, 0x53, 0x48, 0x28,
			0x42, 0xd8, 0xba, 0x64, 0x20, 0x60, 0xb6, 0x4c,
			0xc3, 0xac, 0x5d, 0x93, 0x8c, 0xb9, 0xd4, 0xcc,
			0xb4, 0x9f, 0x31, 0x1f, 0xeb, 0x68, 0x35, 0x58,
		},
	},
	{
		.data_len = 65,
		.digest = {
			0xda, 0xbe, 0xd7, 0xbc, 0x6e, 0xe6, 0x5a, 0x57,
			0xeb, 0x9a, 0x93, 0xaa, 0x66, 0xd0, 0xe0, 0xc4,
			0x29, 0x7f, 0xe9, 0x3b, 0x8e, 0xdf, 0x81, 0x82,
			0x8d, 0x15, 0x11, 0x59, 0x4e, 0x13, 0xa5, 0x58,
		},
	},
	{
		.data_len = 127,
		.digest = {
			0x8c, 0x1a, 0xba, 0x40, 0x66, 0x94, 0x19, 0xf4,
			0x2e, 0xa2, 0xae, 0x94, 0x53, 0x18, 0xb6, 0xfd,
			0xa0, 0x12, 0xc5, 0xef, 0xd5, 0xd6, 0x1b, 0xa1,
			0x37, 0xea, 0x19, 0x44, 0x35, 0x54, 0x85, 0x74,
		},
	},
	{
		.data_len = 128,
		.digest = {
			0xfd, 0x07, 0xd8, 0x77, 0x7d, 0x8b, 0x4f, 0xee,
			0x60, 0x60, 0x26, 0xef, 0x2a, 0x86, 0xfb, 0x67,
			0xeb, 0x31, 0x27, 0x03, 0x99, 0x3c, 0xde, 0xe5,
			0x84, 0x72, 0x71, 0x4c, 0x33, 0x7b, 0x87, 0x13,
		},
	},
	{
		.data_len = 129,
		.digest = {
			0x97, 0xc5, 0x58, 0x38, 0x20, 0xc7, 0xde, 0xfa,
			0xdd, 0x9b, 0x10, 0xc6, 0xc2, 0x2f, 0x94, 0xb5,
			0xc0, 0x33, 0xc0, 0x20, 0x1c, 0x2f, 0xb4, 0x28,
			0x5e, 0x36, 0xfa, 0x8c, 0x24, 0x1c, 0x18, 0x27,
		},
	},
	{
		.data_len = 256,
		.digest = {
			0x62, 0x17, 0x84, 0x26, 0x98, 0x30, 0x57, 0xca,
			0x4f, 0x32, 0xd9, 0x09, 0x09, 0x34, 0xe2, 0xcb,
			0x92, 0x45, 0xd5, 0xeb, 0x8b, 0x9b, 0x3c, 0xd8,
			0xaa, 0xc7, 0xd2, 0x2b, 0x04, 0xab, 0xb3, 0x35,
		},
	},
	{
		.data_len = 511,
		.digest = {
			0x7f, 0xe1, 0x09, 0x78, 0x5d, 0x61, 0xfa, 0x5e,
			0x9b, 0x8c, 0xb1, 0xa9, 0x09, 0x69, 0xb4, 0x24,
			0x54, 0xf2, 0x1c, 0xc9, 0x5f, 0xfb, 0x59, 0x9d,
			0x36, 0x1b, 0x37, 0x44, 0xfc, 0x64, 0x79, 0xb6,
		},
	},
	{
		.data_len = 513,
		.digest = {
			0xd2, 0x3b, 0x3a, 0xe7, 0x13, 0x4f, 0xbd, 0x29,
			0x6b, 0xd2, 0x79, 0x26, 0x6c, 0xd2, 0x22, 0x43,
			0x25, 0x34, 0x9b, 0x9b, 0x22, 0xb0, 0x9f, 0x61,
			0x1d, 0xf4, 0xe2, 0x65, 0x68, 0x95, 0x02, 0x6c,
		},
	},
	{
		.data_len = 1000,
		.digest = {
			0x0c, 0x34, 0x53, 0x3f, 0x0f, 0x8a, 0x39, 0x8d,
			0x63, 0xe4, 0x83, 0x6e, 0x11, 0x7d, 0x14, 0x8e,
			0x5b, 0xf0, 0x4d, 0xca, 0x23, 0x24, 0xb5, 0xd2,
			0x13, 0x3f, 0xd9, 0xde, 0x84, 0x74, 0x26, 0x59,
		},
	},
	{
		.data_len = 3333,
		.digest = {
			0xa8, 0xb8, 0x83, 0x01, 0x1b, 0x38, 0x7a, 0xca,
			0x59, 0xe9, 0x5b, 0x37, 0x6a, 0xab, 0xb4, 0x85,
			0x94, 0x73, 0x26, 0x04, 0xef, 0xed, 0xf4, 0x0d,
			0xd6, 0x09, 0x21, 0x09, 0x96, 0x78, 0xe3, 0xcf,
		},
	},
	{
		.data_len = 4096,
		.digest = {
			0x0b, 0x12, 0x66, 0x96, 0x78, 0x4f, 0x2c, 0x35,
			0xa4, 0xed, 0xbc, 0xb8, 0x30, 0xa6, 0x37, 0x9b,
			0x94, 0x13, 0xae, 0x86, 0xf0, 0x20, 0xfb, 0x49,
			0x8f, 0x5d, 0x20, 0x70, 0x60, 0x2b, 0x02, 0x70,
		},
	},
	{
		.data_len = 4128,
		.digest = {
			0xe4, 0xbd, 0xe4, 0x3b, 0x85, 0xf4, 0x6f, 0x11,
			0xad, 0xc4, 0x79, 0xcc, 0x8e, 0x6d, 0x8b, 0x15,
			0xbb, 0xf9, 0xd3, 0x65, 0xe1, 0xf8, 0x8d, 0x22,
			0x65, 0x66, 0x66, 0xb3, 0xf5, 0xd0, 0x9c, 0xaf,
		},
	},
	{
		.data_len = 4160,
		.digest = {
			0x90, 0x5f, 0xe0, 0xfc, 0xb1, 0xdc, 0x38, 0x1b,
			0xe5, 0x37, 0x3f, 0xd2, 0xcc, 0x48, 0xc4, 0xbc,
			0xb4, 0xfd, 0xf7, 0x71, 0x5f, 0x6b, 0xf4, 0xc4,
			0xa6, 0x08, 0x7e, 0xfc, 0x4e, 0x96, 0xf7, 0xc2,
		},
	},
	{
		.data_len = 4224,
		.digest = {
			0x1f, 0x34, 0x0a, 0x3b, 0xdb, 0xf7, 0x7a, 0xdb,
			0x3d, 0x89, 0x85, 0x0c, 0xd2, 0xf0, 0x0c, 0xbd,
			0x25, 0x39, 0x14, 0x06, 0x28, 0x0f, 0x6b, 0x5f,
			0xe3, 0x1f, 0x2a, 0xb6, 0xca, 0x56, 0x41, 0xa1,
		},
	},
	{
		.data_len = 16384,
		.digest = {
			0x7b, 0x01, 0x2d, 0x84, 0x70, 0xee, 0xe0, 0x77,
			0x3c, 0x17, 0x63, 0xfe, 0x40, 0xd7, 0xfd, 0xa1,
			0x75, 0x90, 0xb8, 0x3e, 0x50, 0xcd, 0x06, 0xb7,
			0xb9, 0xb9, 0x2b, 0x91, 0x4f, 0xba, 0xe4, 0x4c,
		},
	},
};

static const u8 hash_testvec_consolidated[SHA256_DIGEST_SIZE] = {
	0x78, 0x1c, 0xb1, 0x9f, 0xe5, 0xe1, 0xcb, 0x41,
	0x8b, 0x34, 0x00, 0x33, 0x57, 0xc3, 0x1c, 0x8f,
	0x5c, 0x84, 0xc7, 0x8b, 0x87, 0x6a, 0x13, 0x29,
	0x2f, 0xc4, 0x1a, 0x70, 0x5e, 0x40, 0xf2, 0xfe,
};

static const u8 hmac_testvec_consolidated[SHA256_DIGEST_SIZE] = {
	0x56, 0x96, 0x2e, 0x23, 0x3f, 0x94, 0x89, 0x0d,
	0x0f, 0x24, 0x36, 0x2e, 0x19, 0x3d, 0xb5, 0xac,
	0xb8, 0xcd, 0xf1, 0xc9, 0xca, 0xac, 0xee, 0x9d,
	0x62, 0xe6, 0x81, 0xe5, 0x96, 0xf9, 0x38, 0xf5,
};
